<?php

namespace Jiwei\EasyHttpSdk\Exception;

use GuzzleHttp\Exception\ConnectException;
use Jiwei\EasyHttpSdk\Helper\QueryPath;
use Jiwei\EasyHttpSdk\Http\SdkRequest;
use Throwable;

class ApplicationException extends ConnectException implements SdkExceptionInterface
{
    use QueryPath;

    /**
     * @param string $message
     * @param SdkRequest $request
     * @param array<string, mixed> $handlerContext
     * @param Throwable|null $previous
     */
    public function __construct(
        string $message,
        SdkRequest $request,
        array $handlerContext = [],
        ?\Throwable $previous = null,
    ) {
        $this->endpoint = $request->getEndpoint();
        $this->action = $request->getAction();
        parent::__construct($message, $request, $previous, $handlerContext);
    }
}