<?php
declare(strict_types=1);

namespace Jiwei\EasyHttpSdk\Middleware;

use Psr\Http\Message\RequestInterface;
use Ramsey\Uuid\Uuid;

class RequestIDMiddleware implements MiddlewareInterface
{
    /** @var string UUID */
    protected $uuid;

    /**
     * @param string|null $uuid
     */
    public function __construct(string $uuid = null){
        if (!$uuid) {
            $uuid = substr(Uuid::uuid4()->toString(), 0, 8);
        }
        $this->uuid = $uuid;
    }

    /**
     * 为请求添加ID的中间件
     *
     * @param callable $handler
     * @return callable
     */
    public function __invoke(callable $handler): callable
    {
        return function (
            RequestInterface $request,
            array $options
        ) use ($handler) {
            $request = $request->withHeader("X-Request-ID", $this->uuid);
            return $handler($request, $options);
        };
    }
}
