import Vue from 'vue'
import Router from 'vue-router'
Vue.use(Router)


import index from '@/pages/index'
import about from '@/pages/about'
import investment from '@/pages/investment'
import news from '@/pages/news'
import talents from '@/pages/talents'
import contact from '@/pages/contact'
import newinfo from '@/pages/newinfo'

import company from '@/pages/company'
import manager from '@/pages/manager'
import memorabilia from '@/pages/Memorabilia'
import intro from '@/pages/intro'
import team from '@/pages/team'

// 路由规则
var routes = [{
    name: '/index',
    path: '/xmsig/index',
    component: index
}, {
    name: '/about',
    path: '/xmsig/about/intro',
    component: about,
    children: [
        {
          path: '/xmsig/about',
          name: 'intro',
          component: intro
        },
        {
          path: '/xmsig/about/manager',
          name: 'manager',
          component: manager
        },
        {
          path: '/xmsig/about/company',
          name: 'company',
          component: company
        },
        {
          path: '/xmsig/about/memorabilia',
          name: 'memorabilia',
          component: memorabilia
        },
        {
          path: '/xmsig/about/intro',
          name: 'intro',
          component: intro
        },
        {
          path: '/xmsig/about/team',
          name: 'team',
          component: team
        },
      ]
}, {
    name: '/investment',
    path: '/xmsig/investment',
    component: investment
}, {
    name: '/news',
    path: '/xmsig/news',
    component:news
}, {
    name: '/talents',
    path: '/xmsig/talents',
    component: talents
}, {
    name: '/contact',
    path: '/xmsig/contact',
    component: contact
},{
    name: '/newinfo',
    path: '/xmsig/newinfo',
    component: newinfo
}, {
    path: '*',
    redirect: '/xmsig/index'
}]

export default new Router({
    mode:'history',
    routes
})
