package ding

import (
	"context"
	"errors"
	"time"

	"github.com/go-resty/resty/v2"
)

type DingRobotError struct {
	ErrMsg string `json:"errmsg"`
	Code   int    `json:"errcode"`
}

func DingDingNotice(webHook string, ctx context.Context, message DDMessage) error {

	ctx, cancel := context.WithTimeout(ctx, 1*time.Second)
	defer cancel()

	host := webHook
	resultChannel := make(chan DingRobotError)
	errorChannel := make(chan error)

	go func() {
		var errmsg DingRobotError
		client := resty.New()
		_, err := client.R().SetHeader("Content-Type", "application/json").SetBody(&message).SetResult(&errmsg).Post(host)
		if err != nil {
			errorChannel <- err
		}
		resultChannel <- errmsg
	}()

	for {
		select {
		case <-ctx.Done():
			switch ctx.Err() {
			case context.DeadlineExceeded:
				return errors.New("钉钉机器人超时")
			default:
				return errors.New("钉钉机器人失败")
			}
		case result := <-resultChannel:
			if result.Code != 0 {
				return errors.New(result.ErrMsg)
			}
			return nil
		case err := <-errorChannel:
			return err
		}
	}
}
