package conf

type LogTransferConf struct {
	Kafka `ini:"kafka"`
	Etcd  `ini:"etcd"`
	Es    `ini:"es"`
	Log   `ini:"log"`
}

// kafka 配置
type Kafka struct {
	Address string `ini:"address"`
}

// ETCD 配置
type Etcd struct {
	Address string `ini:"address"`
}

// Es 属性
type Es struct {
	Address  string `ini:"address"`
	BulkSize int    `ini:"bulk_size"`
}

type Log struct {
	Keywords string `ini:"service_keyword"`
}

var (
	APPConfig = new(LogTransferConf)
)
