package source

import (
	"log"

	"github.com/y7ut/logtransfer/entity"
	"github.com/y7ut/logtransfer/plugin"
)

// 用于监听Topic改变的 channel
var watchTopicChannel = make(chan *Topic)

// 用于监听Topic启动的 channel
var startTopicChannel = make(chan *Topic)

// 用于监听Topic关闭的 channel
var deleteTopicChannel = make(chan string)

func TopicChangeListener() <-chan *Topic {
	return watchTopicChannel
}

func TopicDeleteListener() <-chan string {
	return deleteTopicChannel
}

func TopicStartListener() <-chan *Topic {
	return startTopicChannel
}

func generateTopic(config TopicConfig) *Topic {

	if config.PipelineConfig == nil {
		log.Printf("get topic setting error:%s ", config.Label)
	}

	p := plugin.PipeLine{}

	for _, v := range config.PipelineConfig {
		currentPlugin, ok := plugin.LoadRegistedPlugins(v.Name)
		if !ok {
			log.Printf("get RegistedPlugins error:%s ", v.Name)
			continue
		}
		err := currentPlugin.SetParams(v.Params)
		if err != nil {
			log.Printf("plugin encode params error: %s", err)
			continue
		}
		p.AppendPlugin(currentPlugin)
	}
	var formatMethod entity.Formater

	switch config.Format {

	case 1:
		formatMethod = entity.DefaultJsonLog
	case 2:
		formatMethod = entity.FormatServiceWfLog
	default:
		formatMethod = entity.DefaultLog

	}

	return &Topic{Name: config.Name, Label: config.Label, PipeLine: &p, Format: formatMethod}
}
