package plugin

var RegistedPlugins = getRegistedPlugins()

// 获取注册过的插件插件列表
func getRegistedPlugins() map[string]HandlerConstruct {
	return map[string]HandlerConstruct{
		"Dump": func() Handler {
			return &Dump{}
		},
		"Edit": func() Handler {
			return &Edit{}
		},
		"SaveES": func() Handler {
			return &SaveES{}
		},
		"Alarm": func() Handler {
			return &Alarm{}
		},
		"DingRobot": func() Handler {
			return &Ding{}
		},
	}
}

// 加载当前注册过的插件
func LoadRegistedPlugins(plugin string) (Handler, bool) {
	h, ok := getRegistedPlugins()[plugin]
	if ok {
		return h(), ok
	}
	return nil, false
}
