package ding

import (
	"bytes"
	"fmt"
	"time"

	"github.com/y7ut/logtransfer/entity"
)

const (
	MARKTYPE                   = "markdown"
	TEXTTYPE                   = "text"
	OPEN_TEMPLE                = "# 服务通知 已开启 \r\n> 运行环境:  \r\n  ######  %s"
	CLOSE_TEMPLE               = "# 服务通知 已关闭 \r\n> 运行环境:  \r\n  ###### %s"
	STATUS_TEMPLE              = "# 服务通知 \r\n> 环境:  \r\n ######  %s"
	MESSAGE_TYPE_OPEN          = "open"
	MESSAGE_TYPE_CLOSE         = "close"
	MESSAGE_TYPE_PLUGIN_NOTICE = "plugin"
)

type DDAt struct {
	IsAtAll   bool     `json:"isAtAll"`
	AtMobiles []string `json:"atMobiles"`
}

type TextContent struct {
	Content string `json:"content,omitempty"`
}

type MarkdownContent struct {
	Title string `json:"title,omitempty"`
	Text  string `json:"text,omitempty"`
}

type DDMessage struct {
	MsgType  string          `json:"msgtype"`
	Markdown MarkdownContent `json:"markdown,omitempty"`
	Text     TextContent     `json:"text,omitempty"`
	At       DDAt            `json:"at"`
}

/**
 * 初始化消息
 *
 * @return string
 */
func CreateDingMessage(messageType string, msg interface{}, mobiles []string) DDMessage {
	var message DDMessage
	message.MsgType = MARKTYPE
	message.Markdown.Title = "服务通知"
	switch messageType {
	case MESSAGE_TYPE_OPEN:
		message.Markdown.Text = fmt.Sprintf(OPEN_TEMPLE, time.Now().Format("2006/01/02 15:04:05"))
	case MESSAGE_TYPE_CLOSE:
		message.Markdown.Text = fmt.Sprintf(CLOSE_TEMPLE, time.Now().Format("2006/01/02 15:04:05"))
	case MESSAGE_TYPE_PLUGIN_NOTICE:
		message.Markdown.Text = pluginNotice(msg)
	default:
		message.Markdown.Text = fmt.Sprintf(STATUS_TEMPLE, time.Now().Format("2006/01/02 15:04:05"))
	}

	if len(mobiles) > 0 {
		message.At.IsAtAll = false
		message.At.AtMobiles = mobiles
	} else {
		message.At.IsAtAll = true
	}

	fmt.Println(message)
	return message
}

func pluginNotice(msg interface{}) string {
	mateData := msg.(*entity.Matedata)
	templateBuff := bytes.NewBuffer([]byte{})
	templateBuff.WriteString(fmt.Sprintf("# 服务通知 \r\n> [节点]:%s", mateData.SourceAgent))
	for key, value := range mateData.Data {
		templateBuff.WriteString(fmt.Sprintf("\r\n> [%s]:%s", key, value))
	}
	templateBuff.WriteString(fmt.Sprintf("######  %s", time.Now().Format("2006/01/02 15:04:05")))
	return templateBuff.String()
}
