package plugin

import (
	"context"
	"log"
	"strings"

	"github.com/y7ut/logtransfer/ding"
	"github.com/y7ut/logtransfer/entity"
)

// 钉钉通知插件
type Ding Plugin

func (d *Ding) HandleFunc(m *entity.Matedata) error {
	log.Println("DINGDING:")
	var dingMobileData = []string{}
	var send bool
	searchKey := (*d.params)["searchKey"].(string)
	searchValue := (*d.params)["searchValue"].(string)
	dingWebHook := (*d.params)["dingWebHook"].(string)
	dingMobiles := (*d.params)["dingMobiles"].(string)
	if dingMobiles != "" {
		dingMobileData = strings.Split(dingMobiles, ",")
	}
	for k, v := range (*m).Data {
		if dingWebHook != "" && k == searchKey && (searchValue == "" || searchValue == v) {
			send = true
			break
		}
	}
	if send {
		msg := ding.CreateDingMessage(ding.MESSAGE_TYPE_PLUGIN_NOTICE, m, dingMobileData)
		err := ding.DingDingNotice(dingWebHook, context.Background(), msg)
		if err != nil {
			log.Println(err)
		}
		log.Println("sendDingDingMsg:", msg.Markdown.Text)
	}

	return nil
}

func (d *Ding) SetParams(params string) error {

	paramsValue, err := checkParams(params, "searchKey", "searchValue", "dingWebHook", "dingMobiles")
	if err != nil {
		return err
	}
	d.params = &paramsValue

	return err
}
